package de.schauderhaft.dbtesting.mothers3;

import org.hibernate.Session;

import de.schauderhaft.dbtesting.model.SuperPower;

public class SuperPowerMother extends
        SingleAlternateKeyObjectMother<SuperPower, String, SuperPowerMother> {

    private String name = "SuperPower";
    SuperPowerTypeMother powerTypeMother;

    public SuperPowerMother(Session s) {
        super(s, SuperPower.class, "SuperPower", "name");
        powerTypeMother = new SuperPowerTypeMother(s);
    }

    @Override
    protected void configureInstance(SuperPower superpower) {
        superpower.description = "Description";
        superpower.type = powerTypeMother.instance();
    }

    @Override
    protected SuperPower createInstance() {
        SuperPower superpower = new SuperPower();
        superpower.name = name;
        return superpower;
    }

    public SuperPowerMother name(String aName) {
        name = aName;
        return this;
    }
}
