package de.schauderhaft.dbtesting.mothers3;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertSame;

import org.junit.Rule;
import org.junit.Test;

import de.schauderhaft.dbtesting.SessionFactoryRule;
import de.schauderhaft.dbtesting.model.SuperPower;

public class SuperHeroMotherTest {

    @Rule
    public final SessionFactoryRule sf = new SessionFactoryRule();

    @Test
    public void testHeroHasSpecifiedName() {
        SuperHeroMother mother = new SuperHeroMother(sf.getSession());
        assertEquals(mother, mother.alternateKey("Eric"));
        assertEquals("Eric", mother.instance().name);
    }

    @Test
    public void testHeroHasSpecifiedWeakness() {
        SuperHeroMother mother = new SuperHeroMother(sf.getSession());
        assertEquals(mother, mother.weakness("weak"));
        assertEquals("weak", mother.instance().weakness);
    }

    @Test
    public void testHeroHasSpecifiedPower() {
        SuperHeroMother mother = new SuperHeroMother(sf.getSession());
        SuperPower power = new SuperPowerMother(sf.getSession()).instance();
        assertEquals(mother, mother.power(power));
        assertEquals(power, mother.instance().power);
    }

    @Test
    public void testHeroHasSpecifiedSecretIdentity() {
        SuperHeroMother mother = new SuperHeroMother(sf.getSession());
        assertEquals(mother, mother.secretIdentity("ich"));
        assertEquals("ich", mother.instance().secretIdentity);
    }

    @Test
    public void testMotherReturnsSameHeroWhenCalledTwice() {
        SuperHeroMother mother = new SuperHeroMother(sf.getSession());
        assertSame(mother.instance(), mother.instance());
    }

    @Test
    public void testTwoMotherReturnSameHeroEntity() {
        SuperHeroMother mother1 = new SuperHeroMother(sf.getSession());
        SuperHeroMother mother2 = new SuperHeroMother(sf.getSession());
        assertSame(mother1.instance().id, mother2.instance().id);
    }

}
