package de.schauderhaft.dbtesting.mothers3;

import org.hibernate.Session;

import de.schauderhaft.dbtesting.model.SuperHero;
import de.schauderhaft.dbtesting.model.SuperPower;

public class SuperHeroMother extends
        SingleAlternateKeyObjectMother<SuperHero, String, SuperHeroMother> {

    private String secretIdentity = "Mr. Jones";
    private String weakness = "None";
    private SuperPower power;

    public SuperHeroMother(Session s) {
        super(s, SuperHero.class, "Name", "name");
        power = new SuperPowerMother(s).instance();
    }

    @Override
    protected void configureInstance(SuperHero hero) {
        hero.power = power;
        hero.weakness = weakness;
        hero.secretIdentity = secretIdentity;
    }

    @Override
    protected SuperHero createInstance() {
        SuperHero hero = new SuperHero();
        hero.name = getAlternateKey();
        return hero;
    }

    public SuperHeroMother secretIdentity(String aSecretIdentity) {
        secretIdentity = aSecretIdentity;
        return this;
    }

    public SuperHeroMother power(SuperPower aPower) {
        power = aPower;
        return this;
    }

    public SuperHeroMother weakness(String aWeakness) {
        weakness = aWeakness;
        return this;
    }

    public SuperHeroMother name(String aName) {
        alternateKey(aName);
        return this;

    }
}
