package de.schauderhaft.dbtesting.mothers3;

import org.hibernate.Session;
import org.hibernate.criterion.Restrictions;

public abstract class SingleAlternateKeyObjectMother<T, A, S extends SingleAlternateKeyObjectMother<T, A, S>>
		extends ObjectMother<T> {

	private final Class<T> objectType;
	private final String alternateKeyName;
	private A alternateKey;

	public SingleAlternateKeyObjectMother(Session s, Class<T> theObjectType,
			A defaultAlternateKey, String theAlternateKeyName) {
		super(s);
		objectType = theObjectType;
		alternateKeyName = theAlternateKeyName;
		alternateKey(defaultAlternateKey);
	}

	@SuppressWarnings("unchecked")
	@Override
	final protected T loadInstance(Session session) {
		return (T) session.createCriteria(objectType)
				.add(Restrictions.eq(alternateKeyName, getAlternateKey()))
				.uniqueResult();

	}

	@SuppressWarnings("unchecked")
	public S alternateKey(A theAlternateKey) {
		alternateKey = theAlternateKey;
		return (S) this;
	}

	public A getAlternateKey() {
		return alternateKey;
	}
}
