package de.schauderhaft.dbtesting.mothers3;

import org.hibernate.Session;

/** create instances of type <tt>T</tt> */
public abstract class ObjectMother<T> {
	private final Session session;

	public ObjectMother(Session s) {
		session = s;
	}

	/** returns an instance based on the configuration of this object mother */
	public T instance() {
		T t = loadInstance(session);
		if (t == null)
			t = createInstance();
		configureInstance(t);
		session.save(t);
		return t;
	}

	/**
	 * configure the instance <tt>t</tt> according to the configuration of this
	 * ObjectMother
	 */
	abstract protected void configureInstance(T t);

	/**
	 * try to load an instance based on the alternate key. Returns null if no
	 * such instance exists
	 */
	abstract protected T loadInstance(Session session);

	/**
	 * create a fresh instance with the alternate key set according to the
	 * configuration of this ObjectMother
	 */
	abstract protected T createInstance();
}
