package de.schauderhaft.dbtesting.mothers2;

import org.hibernate.Session;
import org.hibernate.criterion.Restrictions;

import de.schauderhaft.dbtesting.model.SuperPowerType;

public class SuperPowerTypeMother {

    private final Session session;
    private final String name = "TheType";

    public SuperPowerTypeMother(Session s) {
        session = s;
    }

    public SuperPowerType instance() {
        SuperPowerType powerType = loadInstance();
        if (powerType == null) {
            powerType = createInstance();
        }
        powerType.description = "12345678901234567890aDescription";
        session.save(powerType);
        return powerType;
    }

    private SuperPowerType loadInstance() {
        return (SuperPowerType) session.createCriteria(SuperPowerType.class)
                .add(Restrictions.eq("name", name)).uniqueResult();
    }

    private SuperPowerType createInstance() {
        SuperPowerType powerType = new SuperPowerType();
        powerType.name = name;
        return powerType;
    }
}
