package de.schauderhaft.dbtesting.mothers2;

import org.hibernate.Session;
import org.hibernate.criterion.Restrictions;

import de.schauderhaft.dbtesting.model.SuperPower;

public class SuperPowerMother {

    private final Session session;

    private final String name = "SuperPower";

    public SuperPowerMother(Session s) {
        session = s;
    }

    public SuperPower instance() {
        SuperPower superpower = loadInstance();
        if (superpower == null)
            superpower = createInstance();

        superpower.description = "Description";
        superpower.type = new SuperPowerTypeMother(session).instance();
        session.save(superpower);
        return superpower;
    }

    private SuperPower loadInstance() {
        return (SuperPower) session.createCriteria(SuperPower.class)
                .add(Restrictions.eq("name", name)).uniqueResult();
    }

    private SuperPower createInstance() {
        SuperPower superpower = new SuperPower();
        superpower.name = name;
        return superpower;
    }

}
