package de.schauderhaft.dbtesting.mothers2;

import org.hibernate.Session;
import org.hibernate.criterion.Restrictions;

import de.schauderhaft.dbtesting.model.SuperHero;
import de.schauderhaft.dbtesting.model.SuperPower;

public class SuperHeroMother {
    private final Session session;

    private String secretIdentity = "Mr. Jones";
    private String name = "Name";
    private String weakness = "None";
    private SuperPower power = null;

    public SuperHeroMother(Session s) {
        session = s;
        power = new SuperPowerMother(session).instance();
    }

    public SuperHero instance() {
        SuperHero hero = loadInstance();
        if (hero == null) {
            hero = createInstance();
        }
        hero.power = power;
        hero.weakness = weakness;
        hero.secretIdentity = secretIdentity;
        session.save(hero);
        return hero;
    }

    private SuperHero loadInstance() {
        return (SuperHero) session.createCriteria(SuperHero.class)
                .add(Restrictions.eq("name", name)).uniqueResult();

    }

    private SuperHero createInstance() {
        SuperHero hero = new SuperHero();
        hero.name = name;
        return hero;
    }

    public SuperHeroMother name(String aName) {
        name = aName;
        return this;
    }

    public SuperHeroMother secretIdentity(String aSecretIdentity) {
        secretIdentity = aSecretIdentity;
        return this;
    }

    public SuperHeroMother power(SuperPower aPower) {
        power = aPower;
        return this;
    }

    public SuperHeroMother weakness(String aWeakness) {
        weakness = aWeakness;
        return this;
    }
}
