package de.schauderhaft.dbtesting;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;

import java.util.List;

import org.junit.Rule;
import org.junit.Test;

import de.schauderhaft.dbtesting.model.SuperHero;
import de.schauderhaft.dbtesting.mothers3.SuperHeroMother;

public class SuperHeroRepository4Test {

    @Rule
    public final SessionFactoryRule sf = new SessionFactoryRule();

    @Test
    public void returnsHerosWithMatchingType() {
        SuperHeroMother mother = new SuperHeroMother(sf.getSession());
        SuperHero hero = mother.instance();
        SuperHero hero2 = mother.name("Jens").instance();

        sf.flush();

        SuperHeroRepository heroRepository = new SuperHeroRepository(
                sf.getSession());
        List<SuperHero> heroes = heroRepository.findBy(hero.power);

        assertNotNull(heroes);
        assertEquals(1, heroes.size());
    }
}
