package de.schauderhaft.dbtesting.model;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.ManyToOne;
import javax.validation.constraints.NotNull;

import org.hibernate.validator.constraints.NotEmpty;

@Entity
public class SuperHero extends AbstractEntity {

    @NotEmpty
    @Column(unique = true)
    public String name;

    @ManyToOne
    @NotNull
    public SuperPower power;

    @NotEmpty
    public String weakness;

    @NotEmpty
    public String secretIdentity;
}