package de.schauderhaft.dbtesting;

import java.util.List;

import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Restrictions;

import de.schauderhaft.dbtesting.model.SuperHero;
import de.schauderhaft.dbtesting.model.SuperPower;

public class SuperHeroRepository {

    private final Session session;

    public SuperHeroRepository(Session aSession) {
        session = aSession;
    }

    @SuppressWarnings("unchecked")
    public List<SuperHero> findBy(SuperPower superpower) {
        Criteria criteria = session.createCriteria(SuperHero.class).add(
                Restrictions.eq("power", superpower));

        return criteria.list();
    }

}
